local assets =
{
    Asset("ANIM", "anim/moonmonster.zip"),
    Asset("ANIM", "anim/krampus_build.zip"),
    Asset("SOUND", "sound/krampus.fsb"),
}

local prefabs =
{
    "charcoal",
    "monstermeat",
    "krampus_sack",
}

local brain = require "brains/frogbrain"
local function OnGoingHome(inst)
    SpawnPrefab("frogsplash").Transform:SetPosition(inst.Transform:GetWorldPosition())
end
SetSharedLootTable( 'moonmonster',
{
    {'monstermeat',  1.0},
    {'charcoal',     1.0},
    {'charcoal',     1.0},
    {'krampus_sack', .01},
})

local function NotifyBrainOfTarget(inst, target)
    if inst.brain and inst.brain.SetTarget then
        inst.brain:SetTarget(target)
    end
end

local function makebagfull(inst)
    inst.AnimState:Show("SACK")
    inst.AnimState:Hide("ARM")
end

local function makebagempty(inst)
    inst.AnimState:Hide("SACK")
    inst.AnimState:Show("ARM")
end

local function OnAttacked(inst, data)
    inst.components.combat:SetTarget(data.attacker)
    inst.components.combat:ShareTarget(data.attacker, 300, function(dude) return dude:HasTag("moonmonster") and not dude.components.health:IsDead() end, 5)
end

local function OnNewCombatTarget(inst, data)
    NotifyBrainOfTarget(inst, data.target)
end
local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    inst.entity:AddDynamicShadow()
    inst.entity:AddNetwork()
    inst.entity:AddLightWatcher()

    MakeCharacterPhysics(inst, 10, .5)

    inst.DynamicShadow:SetSize(3, 1)
    inst.Transform:SetFourFaced()

    inst:AddTag("scarytoprey")
    inst:AddTag("monster")
    inst:AddTag("hostile")
    inst:AddTag("moonmonster")
	inst.AnimState:Hide("ARM_carry")
    inst.AnimState:Show("ARM_normal")

    inst.AnimState:Hide("ARM")
    inst.AnimState:SetBank("wilson")
    inst.AnimState:SetBuild("moonmonster")
    inst.AnimState:PlayAnimation("idle", true)

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end

    inst:AddComponent("inventory")
    inst.components.inventory.ignorescangoincontainer = true

    inst:AddComponent("locomotor") -- locomotor must be constructed before the stategraph
    inst.components.locomotor.runspeed = 6
    inst:SetStateGraph("SGshadowwaxwell")

    inst:SetBrain(brain)

    MakeLargeBurnableCharacter(inst, "krampus_torso")
    MakeLargeFreezableCharacter(inst, "krampus_torso")
    inst:AddComponent("sleeper")
    inst:AddComponent("health")
	inst:AddComponent("thief")
    inst.components.health:SetMaxHealth(150)
	   inst:ListenForEvent("death", function()
        local pt1 = inst:GetPosition()
        for k = 1,math.random(0,2) do
            local gold = SpawnPrefab("goldnugget")
            gold.Transform:SetPosition(pt1.x+(math.random(3)-math.random(3)), 0, pt1.z+(math.random(3)-math.random(3)))
        end
		
    end )

    inst:AddComponent("combat")
    inst.components.combat:SetDefaultDamage(20)
    inst.components.combat:SetAttackPeriod(1)
    inst.components.combat:SetRetargetFunction(2, function(inst)
        if not inst.components.health:IsDead() then
            return FindEntity(inst, 20, function(guy)
                return inst.components.combat:CanTarget(guy) and not guy:HasTag("moonmonster")
            end )
        end
    end )
    inst.components.combat.onhitotherfn = function(inst, other, damage) inst.components.thief:StealItem(other) end
    inst:ListenForEvent("attacked", function(inst, data)
        inst.components.combat:SetTarget(data.attacker)
        inst.components.combat:ShareTarget(data.attacker, 30, function(dude) return dude:HasTag("moonmonster") and not dude.components.health:IsDead() end, 5)
    end )
    inst.Physics:SetCollisionCallback(function(inst, other)
        if other and other.components.workable and other.components.workable.workleft > 0 then
           other.components.workable:Destroy(inst)
        end
    end)
    inst:DoPeriodicTask(.7, function(inst)
        local pos = Vector3(inst.Transform:GetWorldPosition())
        local ents = TheSim:FindEntities(pos.x,pos.y,pos.z, 3)
        for k,v in pairs(ents) do
            if v.components.pickable and v.components.pickable:CanBePicked() then
               v.components.pickable:Pick(inst)
            end
            if v.components.crop then
               v.components.crop:Harvest(inst)
            end
        end
		--
		if not inst.components.health:IsDead() then
		local x, y, z = inst.Transform:GetWorldPosition()
    local ents = TheSim:FindEntities(x, y, z, TUNING.ORANGEAMULET_RANGE, { "_inventoryitem" }, { "INLIMBO", "NOCLICK", "catchable", "fire", "minesprung", "mineactive" })
    for i, v in ipairs(ents) do
        if v.components.inventoryitem ~= nil and
            v.components.inventoryitem.canbepickedup and
            v.components.inventoryitem.cangoincontainer and
            not v.components.inventoryitem:IsHeld() and
            inst.components.inventory:CanAcceptCount(v, 1) > 0 then

            --Amulet will only ever pick up items one at a time. Even from stacks.
            SpawnPrefab("sand_puff").Transform:SetPosition(v.Transform:GetWorldPosition())

  local v_pos = v:GetPosition()
            if v.components.stackable ~= nil then
                v = v.components.stackable:Get()
            end

            if v.components.trap ~= nil and v.components.trap:IsSprung() then
                v.components.trap:Harvest(inst)
            else
                inst.components.inventory:GiveItem(v, nil, v_pos)
            end
			end
          
        end
    end
    end )
    local minimap = inst.entity:AddMiniMapEntity()
    minimap:SetIcon( "purplemooneye.png" )

    inst:AddComponent("lootdropper")
    inst.components.lootdropper:SetChanceLootTable('moonmonster')

    inst:AddComponent("inspectable")
    inst.components.inspectable:RecordViews()
	inst:AddComponent("knownlocations")


    inst:ListenForEvent("attacked", OnAttacked)
    inst:ListenForEvent("newcombattarget", OnNewCombatTarget)
	inst:ListenForEvent("goinghome", OnGoingHome)

    MakeHauntablePanic(inst)
	MakeSnowCovered(inst)

    return inst
end

return Prefab("moonmonster", fn, assets, prefabs)
